//
//  YHCancelAppointAlertView.swift
//  galaxy
//
//  Created by edy on 2024/8/23.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHCancelAppointAlertView: UIView {

    let baseTag = 9527
    
    var selectBlock: ((Bool) -> Void)?
    
    var memberNamesText: String = "" {
        
        didSet {
            let a: ASAttributedString = .init("取消预约后，不可恢复，您可重新预约！成员：", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor(alpha: 0.7)))
            let b: ASAttributedString = .init("\(memberNamesText)", .font(UIFont.PFSC_B(ofSize: 14)), .foreground(UIColor.brandMainColor))
            detailLabel.attributed.text = a+b
        }
    }
    
    // 底层蒙版
    lazy var blackMaskView: UIView = {
        let view = UIView()
        view.backgroundColor = .alertMaskColor
        return view
    }()
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    lazy var iconImgView: UIImageView = {
        let view = UIImageView(image: UIImage(named: "cs_family_risk"))
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textAlignment = .center
        label.font = UIFont.PFSC_M(ofSize: 17)
        label.textColor = UIColor.mainTextColor
        label.text = "取消预约"
        return label
    }()
    
    lazy var detailLabel: UILabel = {
        var label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 14.0)
        return label
    }()
    
    lazy var cancelBtn: UIButton = {
        let button = UIButton()
        button.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
        button.setTitle("否", for: .normal)
        button.setTitleColor(UIColor.white, for: .normal)
        button.backgroundColor = .brandMainColor
        button.tag = baseTag + 0
        button.layer.cornerRadius = kCornerRadius3
        return button
    }()
    
    lazy var confirmBtn: UIButton = {
        let button = UIButton()
        button.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
        button.setTitle("是", for: .normal)
        button.setTitleColor(UIColor.brandMainColor, for: .normal)
        button.backgroundColor = .white
        button.layer.borderWidth = 1.0
        button.tag = baseTag + 1
        button.layer.borderColor = UIColor.brandMainColor.cgColor
        button.layer.cornerRadius = kCornerRadius3
        return button
    }()
    
    @objc func didConfirmBtnClicked(_ sender: UIButton) {
        let tag = sender.tag-self.baseTag
        dismiss()
        selectBlock?(tag == 1)
    }
    
    static func alertView() -> YHCancelAppointAlertView {
        let view = YHCancelAppointAlertView(frame: UIScreen.main.bounds)
        return view
    }
    
    @objc func show() {
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
    }
    
    @objc func dismiss() {
        self.removeFromSuperview()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    func createUI() {
        
        self.addSubview(blackMaskView)
        self.addSubview(whiteContentView)
        whiteContentView.addSubview(iconImgView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(detailLabel)
        whiteContentView.addSubview(confirmBtn)
        whiteContentView.addSubview(cancelBtn)

        confirmBtn.addTarget(self, action: #selector(didConfirmBtnClicked(_:)), for: .touchUpInside)
        cancelBtn.addTarget(self, action: #selector(didConfirmBtnClicked(_:)), for: .touchUpInside)
        
        blackMaskView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(38)
            make.right.equalTo(-38)
            make.centerY.equalToSuperview()
        }
        
        iconImgView.snp.makeConstraints { make in
            make.width.height.equalTo(53)
            make.top.equalTo(30)
            make.centerX.equalToSuperview()
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(iconImgView.snp.bottom).offset(16)
            make.height.equalTo(24)
            make.left.equalTo(21)
            make.right.equalTo(-21)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.top.equalTo(titleLabel.snp.bottom).offset(8)
        }
        
        confirmBtn.snp.makeConstraints { make in
            make.top.equalTo(detailLabel.snp.bottom).offset(30)
            make.left.equalTo(21)
            make.right.equalTo(cancelBtn.snp.left).offset(-8)
            make.bottom.equalTo(-21)
            make.height.equalTo(45)
            make.width.equalTo(cancelBtn)
        }
        
        cancelBtn.snp.makeConstraints { make in
            make.centerY.equalTo(confirmBtn)
            make.height.equalTo(45)
            make.right.equalTo(-21)
        }
    }
}
